//------------------------------------------------------------
// Copyright Sandlot Games, 2007
// author: Michael Felice
// file: client_savequesthud.cs
// brief:
//    This saves the quest data and loads the data to and from
// a file.  This is required for saving and loading.
//------------------------------------------------------------

// saves quest information to a file
function QuestHudSaveToFile()
{
   // save the quest load state
   slgSaveBool(QuestInfoGroup.visible == true);
   
   // save base quest numbers
   slgSaveInt($QuestButtonSelected);
   
   // saves each of the quest button details
   slgSaveInt($QuestWindowCount);
   for (%index = 0; %index < $QuestWindowCount; %index++)
   {
      %button = $QuestWindowButtons[%index];
      slgSaveString(%button.position);
      slgSaveString(%button.quest);
      slgSaveInt(%button.taskCount);
      %button.SaveToFile();

      // save the task information for the quest
      for (%taskIndex = 0; %taskIndex < %button.taskCount; %taskIndex++)
      {
         %taskName = %button.tasks[%taskIndex, 0].stateUp;
         %taskSelected = %button.tasks[%taskIndex, 1].selected;

         slgSaveBool(%taskSelected);
         slgSaveString(%taskName);
         slgSaveString(%button.tasks[%taskIndex, 1].position);
         slgSaveString(%button.tasks[%taskIndex, 0].position);
         
         if (%taskSelected == true)
         {
            %timer = %button.tasks[%taskIndex, 0].timer;
            slgSaveInt(%button.tasks[%taskIndex, 0].timerPhase);
            slgSaveFloat(%timer.getElapsedTime());
         }
         
         %button.tasks[%taskIndex, 0].SaveToFile();
         %button.tasks[%taskIndex, 1].SaveToFile();
      }
   }

   // save the quest slider timers (this is necessary because everything
   // that slides is velocity-based, so the last time has to be correct
   // relative to the timer's time)
   %sliderTimer = isObject($QuestSlideTimer);
   slgSaveBool(%sliderTimer);
   if (%sliderTimer == true)
   {
      %totalTime = $QuestSlideTimer.getTotalTime();
      %elapsedTime = $QuestSlideTimer.getElapsedTime();
      slgSaveFloat(%totalTime);
      slgSaveFloat(%elapsedTime);
   }
   slgSaveFloat($QuestLastTime);
}

// loads quest information from a file
function QuestHudLoadFromFile()
{
   // load if the quests are toggled on or off
   if (slgLoadBool() == true) TurnQuestsOn();
   else TurnQuestsOff();
   
   // load base quest numbers
   $QuestButtonSelected = slgLoadInt();
   
   // loads each of the quest button details
   $QuestWindowCount = slgLoadInt();
   for (%index = 0; %index < $QuestWindowCount; %index++)
   {
      %button = new SLImage()
      {
         visible = "1";
         input = "1";
         onTop = "1";
         horizSizing = "relative";
         vertSizing = "relative";
         stateUp = $QuestBaseButton.stateUp;
         stateFocus = $QuestBaseButton.stateFocus;
         stateDown = $QuestBaseButton.stateFocus;
         position = slgLoadString();
         extent = $QuestBaseButton.extent;
      };
      %button.command = "SelectButton(" @ %button @ ");";
      %button.quest = slgLoadString();
      %button.taskCount = slgLoadInt();
      
      // handle quest selection (if the quest is added and should be
      // selected, then select it, otherwise, set it in the unselected
      // state
      if ($QuestButtonSelected == %index)
      {
         %button.color = $QuestSelectHighlight;
         $QuestTextName.stateUp = %button.quest;
         
         %button.stateUp = $QuestBaseButton.stateDown;
         %button.stateFocus = $QuestBaseButton.stateDown;
         %button.stateDown = $QuestBaseButton.stateDown;
      }
      else
      {
         %button.color = $QuestDeselectHighlight;
      }

      // add the quest icon gui control and make sure the window
      // accuractely reports the new quest that was added
      $QuestWindowHud.addGuiControl(%button);
      $QuestWindowButtons[%index] = %button;
      %button.LoadFromFile();
      
      // load the task information for the quest
      for (%taskIndex = 0; %taskIndex < %button.taskCount; %taskIndex++)
      {
         %taskSelected = slgLoadBool();
         %taskName = slgLoadString();
         
         %mimicButton = nameToId("QuestTaskImage" @ %taskIndex);
         %button.tasks[%taskIndex, 1] = new SLImage()
         {
            visible = "0";
            input = "0";
            stateUp = %mimicButton.stateUp;
            stateDown = %mimicButton.stateDown;
            color = %mimicButton.color;
            profile = %mimicButton.profile;
            horizSizing = %mimicButton.horizSizing;
            vertSizing = %mimicButton.vertSizing;
            position = slgLoadString();
            extent = %mimicButton.extent;
            iconOffset = %mimicButton.iconOffset;
            iconAlpha = %mimicButton.iconAlpha;
            iconEnabled = %mimicButton.iconEnabled;
            iconDisabled = %minicButton.iconDisabled;
            selected = %taskSelected;
         };
         QuestInfoGroup.addGuiControl(%button.tasks[%taskIndex, 1]);
         
         // add the task and tell it that it is not complete
         %mimicButton = nameToId("QuestTaskText" @ %taskIndex);
         %button.tasks[%taskIndex, 0] = new SLText()
         {
            textVerticalCenter = "1";
            visible = "0";
            input = "0";
            profile = %mimicButton.profile;
            horizSizing = %mimicButton.horizSizing;
            vertSizing = %mimicButton.vertSizing;
            position = slgLoadString();
            extent = %mimicButton.extent;
            iconOffset = %mimicButton.iconOffset;
            iconAlpha = %mimicButton.iconAlpha;
            iconEnabled = %mimicButton.iconEnabled;
            iconDisabled = %minicButton.iconDisabled;
            stateUp = %taskName;
         };
         QuestInfoGroup.addGuiControl(%button.tasks[%taskIndex, 0]);
         
         if (%taskSelected == true)
         {
            %timerPhase = slgLoadInt();
            %button.tasks[%taskIndex, 0].timerPhase = %timerPhase;
            
            if (%timerPhase == 1)
            {
               // create the timer that will determine when the check
               // is removed from the list of tasks
               %timer = new SLTimer()
               {
                  time = $QuestTaskWaitTime;
               };
               %timer.setElapsedTime(slgLoadFloat());
               %timer.notifyOnFire(FadeTaskTimer, %timer);
               %timer.button = %button;
               %timer.task = %taskName;
               %button.tasks[%taskIndex, 0].timer = %timer;
            }
            else
            {
               %timer = new SLTimer()
               {
                  time = $QuestTaskFadeTime;
               };
               %timer.setElapsedTime(slgLoadFloat());
               %timer.notifyOnFire(RemoveTaskTimer, %timer);
               %timer.quest = %button.quest;
               %timer.task = %taskName;
               %button.tasks[%taskIndex, 0].timer = %timer;
            }
         }
         
         %button.tasks[%taskIndex, 0].LoadFromFile();
         %button.tasks[%taskIndex, 1].LoadFromFile();
      }
      
      // if this particular task is visible, update the tasks
      if ($QuestButtonSelected == %index)
      {
         ShowTasks(%button);
      }
   }
   
   // load the quest slider timers (this is necessary because everything
   // that slides is velocity-based, so the last time has to be correct
   // relative to the timer's time)
   %sliderTimer = slgLoadBool();
   if (%sliderTimer == true)
   {
      %totalTime = slgLoadFloat();
      %elapsedTime = slgLoadFloat();
      $QuestSlideTimer.time = %totalTime;
      $QuestSlideTimer.setElapsedTime(%elapsedTime);
   }
   $QuestLastTime = slgLoadFloat();
}

